####################
##############
### AESO ILF State-2 Main Script
#########################

import wx
import os
import sys
from datetime import datetime
from datetime import timedelta as td

	
	
class MyFrame(wx.Frame):
	def __init__(self, parent, id, title):
		wx.Frame.__init__(self, parent, id, title, (-1, -1), wx.Size(400, 500))
		hbox = wx.BoxSizer(wx.HORIZONTAL)
		

		self.inputdir = os.path.join(os.getcwd(), 'Input Files')
		self.logFiles = []
		self.caseFiles = []
		
				
		########## PANEL 1 ##############
		#######################################
		panel1 = wx.Panel(self, -1, style=wx.SIMPLE_BORDER)
		hbox_p1 = wx.BoxSizer(wx.VERTICAL)
		
		box1 = wx.BoxSizer(wx.VERTICAL)
		box_action = wx.BoxSizer(wx.VERTICAL)
		hbox_p1.Add( box1, 1, wx.EXPAND, 5 )
		hbox_p1.Add( box_action, 1, wx.EXPAND, 5 )
		
		# box1 = box_input
		self.inputdir_button = wx.Button(panel1, -1, 'Browse')
		self.s1cases_button = wx.Button(panel1, -1, 'Select State-1 Cases', size=(150,30))
		self.s1logs_button = wx.Button(panel1, -1, 'Select State-1 Log Files', size=(150,30))
		
		self.m_staticTextTitle = wx.StaticText( panel1, wx.ID_ANY, u"AESO ILF (State-2)", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticTextTitle.Wrap( -1 )
		self.m_staticTextTitle.SetFont( wx.Font( 16, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, False, wx.EmptyString ) )
		self.m_staticText_inputdir2 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_inputdir3 = wx.StaticText( panel1, wx.ID_ANY, u"Input Files Directory Path", wx.DefaultPosition, wx.DefaultSize, 0 )
		
		
		self.m_staticText_inputdir4 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_inputdir5 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_staticText_inputdir6 = wx.StaticText( panel1, wx.ID_ANY, u"", wx.DefaultPosition, wx.DefaultSize, 0 )
		self.m_textCtr_inputdir = wx.TextCtrl( panel1, wx.ID_ANY, wx.EmptyString, wx.DefaultPosition, wx.DefaultSize, 0 )
		
		box1.Add(self.m_staticTextTitle, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir2, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir3, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		
		box1.Add(self.m_textCtr_inputdir, 0,  wx.ALIGN_CENTER|wx.EXPAND|wx.ALL, 5)
		box1.Add(self.inputdir_button, 0,  wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir4, 0,  wx.ALL, 5)
		
		box1.Add(self.s1cases_button,0, wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.s1logs_button,0, wx.ALIGN_CENTER|wx.ALL, 5)
		self.prepCase = wx.Button(panel1, -1, 'Start State-2', size=(150,30))
		box1.Add(self.prepCase,0, wx.ALIGN_CENTER|wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir5, 0,  wx.ALL, 5)
		box1.Add(self.m_staticText_inputdir6, 0,  wx.ALL, 5)
		
		self.exitButton = wx.Button(panel1, -1, 'Exit', size=(150,30))
		box1.Add(self.exitButton,0, wx.ALIGN_CENTER|wx.ALL, 5)
		
		
		panel1.SetSizer(hbox_p1)
		
		
		############### EVENT DESCRIPTIONS ##############
		self.Bind (wx.EVT_BUTTON, self.OnInputDir, self.inputdir_button)
		self.Bind (wx.EVT_BUTTON, self.OnSelectS1Cases, self.s1cases_button)
		self.Bind (wx.EVT_BUTTON, self.OnLogfiles, self.s1logs_button)
		self.Bind (wx.EVT_BUTTON, self.onStartS2, self.prepCase)
		self.Bind (wx.EVT_BUTTON, self.onExit, self.exitButton)
		
		
		################ Add Panel 1, to hbox
		hbox.Add(panel1, 1, wx.EXPAND | wx.ALL, 0)
		
		############## Frame Set Sizer #########
		# self.SetSize((400, 120))
		self.SetSizer(hbox)
		self.Centre()
	
	def onExit(self, event):
		# self.Hide()
		self.Destroy()
		# import ilfmain_lossInfo
		# self.secondWindow = ilfmain_lossInfo.main()
		# self.Bind(wx.EVT_CLOSE, self.on_close, self.secondWindow)
		
		
		
	def OnInputDir(self, event):
		wildcard = ""
		dlg = wx.DirDialog(None, "Browse for Input Files directory",style=wx.DD_DEFAULT_STYLE | wx.DD_NEW_DIR_BUTTON)
		if dlg.ShowModal() == wx.ID_OK:
			# print dlg.GetPath()
			self.inputdir =  dlg.GetPath()
			self.m_textCtr_inputdir.SetValue(str(self.inputdir))
		print "Selected Input Folder : "
		print self.inputdir
		dlg.Destroy()
	
	def onStartS2(self, event):
		# print self.dates
		import getLossInfo
		getLossInfo.ilf_main(self.caseFiles, self.inputdir, self.logFiles)

		
	def OnSelectS1Cases(self, event):
		wildcard=""
		self.caseFiles =[]
		# dlg = wx.FileDialog(self, "Choose a file", os.getcwd(), "", wildcard, wx.FD_OPEN)
		dlg = wx.FileDialog(self, "Choose Topology Cases", os.getcwd(), "", "*.sav", wx.FD_MULTIPLE)
		# dlg = wx.FileDialog(self, "Choose a file", "", "", "*.*", wx.FD_MULTIPLE)
		if dlg.ShowModal() == wx.ID_OK:
			files =  dlg.GetPaths()
			for file in files:
				file = str(file)
				# print file
				self.caseFiles.append(file)
		dlg.Destroy()
	
	def OnLogfiles(self, event):
		wildcard=""
		self.logFiles =[]
		# dlg = wx.FileDialog(self, "Choose a file", os.getcwd(), "", wildcard, wx.FD_OPEN)
		dlg = wx.FileDialog(self, "Choose State-1 Log Files", os.getcwd(), "", "*.log", wx.FD_MULTIPLE)
		# dlg = wx.FileDialog(self, "Choose a file", "", "", "*.*", wx.FD_MULTIPLE)
		if dlg.ShowModal() == wx.ID_OK:
			files =  dlg.GetPaths()
			for file in files:
				file = str(file)
				print file
				self.logFiles.append(file)
		dlg.Destroy()

class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, 'AESO ILF - State 2')
        frame.Show(True)
        return True

app = MyApp(0)
app.MainLoop()
